<?php defined('BASEPATH') OR exit('No direct script access allowed'); ?>
<?php defined('BASEPATH') OR exit('No direct script access allowed'); ?>

<!-- Add Flash Messages Here -->
<?php if($this->session->flashdata('message')): ?>
    <div class="container py-3">
        <div class="alert alert-<?php echo $this->session->flashdata('message_type'); ?> alert-dismissible fade show" role="alert">
            <?php echo $this->session->flashdata('message'); ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    </div>
<?php endif; ?>

<div class="container py-5">
<div class="container py-5">
    <div class="row">
        <div class="col-lg-8 mb-4">
            <div class="card shadow border-0">
                <div class="card-body p-4 p-md-5">
                    <h3 class="fw-bold mb-4">Send Us a Message</h3>
                    
                    <?php echo form_open('contact/submit'); ?>
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label fw-bold">Name <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" name="name" value="<?php echo set_value('name'); ?>" required>
                                <?php echo form_error('name', '<small class="text-danger">', '</small>'); ?>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label fw-bold">Email <span class="text-danger">*</span></label>
                                <input type="email" class="form-control" name="email" value="<?php echo set_value('email'); ?>" required>
                                <?php echo form_error('email', '<small class="text-danger">', '</small>'); ?>
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label fw-bold">Phone</label>
                                <input type="tel" class="form-control" name="phone" value="<?php echo set_value('phone'); ?>">
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label fw-bold">Subject <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" name="subject" value="<?php echo set_value('subject'); ?>" required>
                                <?php echo form_error('subject', '<small class="text-danger">', '</small>'); ?>
                            </div>
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label fw-bold">Message <span class="text-danger">*</span></label>
                            <textarea class="form-control" name="message" rows="6" required><?php echo set_value('message'); ?></textarea>
                            <?php echo form_error('message', '<small class="text-danger">', '</small>'); ?>
                        </div>
                        
                        <button type="submit" class="btn btn-primary btn-lg">
                            <i class="fas fa-paper-plane"></i> Send Message
                        </button>
                    <?php echo form_close(); ?>
                </div>
            </div>
        </div>
        
        <div class="col-lg-4">
            <div class="card shadow border-0 mb-4">
                <div class="card-body p-4">
                    <h5 class="fw-bold mb-3">Contact Information</h5>
                    
                    <?php if (!empty($site_settings['site_email'])): ?>
                        <div class="mb-3">
                            <i class="fas fa-envelope text-primary fa-lg me-2"></i>
                            <a href="mailto:<?php echo $site_settings['site_email']; ?>">
                                <?php echo $site_settings['site_email']; ?>
                            </a>
                        </div>
                    <?php endif; ?>
                    
                    <?php if (!empty($site_settings['site_phone'])): ?>
                        <div class="mb-3">
                            <i class="fas fa-phone text-primary fa-lg me-2"></i>
                            <a href="tel:<?php echo $site_settings['site_phone']; ?>">
                                <?php echo $site_settings['site_phone']; ?>
                            </a>
                        </div>
                    <?php endif; ?>
                    
                    <?php if (!empty($site_settings['site_address'])): ?>
                        <div class="mb-3">
                            <i class="fas fa-map-marker-alt text-primary fa-lg me-2"></i>
                            <?php echo nl2br($site_settings['site_address']); ?>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
            
            <div class="card shadow border-0" style="background: linear-gradient(135deg, #f26124, #8105bf);">
                <div class="card-body p-4 text-white text-center">
                    <h5 class="fw-bold mb-3">Office Hours</h5>
                    <p class="mb-2"><strong>Monday - Friday</strong></p>
                    <p class="mb-2">9:00 AM - 5:00 PM</p>
                    <hr style="border-color: rgba(255,255,255,0.3);">
                    <p class="mb-0">We typically respond within 24-48 hours</p>
                </div>
            </div>
        </div>
    </div>
</div>